import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';

import '../Models/rentalContactResponse.dart';
import '../Services/api_calling.dart';


class RentalContactProvider extends ChangeNotifier {
  bool _isLoading = false;
  RentalContactResponse? _rentalContact;
  String? _errorMessage;

  // Getters
  bool get isLoading => _isLoading;
  RentalContactResponse? get rentalContact => _rentalContact;
  String? get errorMessage => _errorMessage;

  /// Call API and fetch rental contact
  Future<void> fetchRentalContactData(
      BuildContext context,
      String sessionId,
      String empId,
      String mob,
      ) async {
    try {
      _isLoading = true;
      _errorMessage = null;
      notifyListeners();

      final data =
      await ApiCalling.fetchRentalContactApi(sessionId, empId, mob);
      debugPrint("############################### provider called!");
      if (data != null) {
        _rentalContact = data;
        debugPrint(" Rental Contact fetched: ${data.toJson()}");

        if (data.error == 0) {
          // success
          // toast(context, "Rental Contact fetched successfully");
        } else {
          // API returned error
          _errorMessage = data.message ?? "Unknown error";
          // toast(context, _errorMessage!);
        }
      } else {
        _errorMessage = "No response from server";
        // toast(context, _errorMessage!);
      }
    } catch (e) {
      _errorMessage = "❌ Exception: $e";
      debugPrint(_errorMessage);
      // toast(context, "Something went wrong");
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  /// Reset state if needed
  void reset() {
    _rentalContact = null;
    _errorMessage = null;
    _isLoading = false;
    notifyListeners();
  }
}
